/* -*-C-*-
 ##############################################################################
 #
 # File:        trice/inc/trice.h
 # RCS:         "@(#)$Revision: 1.22 $ $Date: 94/03/18 15:55:32 $"
 # Description: header file for definitions internal to E1430 device library
 # Author:      Doug Passey
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # This is the header file for the hardware driver for the E1430 VXI module.
 # It contains the defines and typedefs internal to the driver code.  It
 # will help to understand this file if you have a E1430 ERS.
 #
 # Revisions:
 #
 ##############################################################################
*/


#ifndef _TRICE_INCLUDED
#define _TRICE_INCLUDED

#if defined _MSDOS
#  define _STDIN_
#  if defined _WINDLL
     int __cdecl printf(const char *, ...);
#  endif
#endif


#include "machType.h"

#    include <setjmp.h>
#    ifdef EMULATE_SICL
#      include "sicl_e.h"
#    else
#      include <sicl.h>
#    endif

#include "e1430.h"


#ifndef NULL
#define NULL	0
#endif

#define PI	3.14159265358979323846

/* number of range step */
#define RANGE_STEPS	11

/* factor to multiply range scale factor to get ADC Clipping Voltage */
#define KESTREL_FACTOR		0.433430434

/* defines for state of sync line */
#define E1430_SYNC_LINE_HIGH		1
#define E1430_SYNC_LINE_LOW		0

/* defines timeout for trigger and arm */
#define TRICE_TIMEOUT		5L

/* defines for dummy registers to save state variables that are not registers */
#define TRIGGER_LEVEL_SAVE		0x100
#define TRIGGER_SLOPE_SAVE		0x101
#define TRIGGER_LEVEL_SAVE_ADC_MASK	(~0x00FF)
#define TRIGGER_LEVEL_SAVE_MAG_MASK	(~0xFF00)
#define TRIGGER_LEVEL_SAVE_MAG_BIT_SHIFT 8

/* defines for VXI ID register */
#define VXI_DEVICE_DEFAULT			(0xFFFF)

/* defines for VXI device type register */
#define VXI_DEVICE_TYPE_MASK			(0x0FFF)
#define TRICE_DEVICE_TYPE			(0x01C6)

/* defines for the bit positions of the VXI Control Register */
#define VXI_CONTROL_RESET_ON			(1)
#define VXI_CONTROL_RESET_OFF			(0)

/* defines for the Analog Setup register */
#define ANALOG_SETUP_ANTIALIAS_MASK		(~0x0020)
#define ANALOG_SETUP_ANTIALIAS_ON		(0x0000)
#define ANALOG_SETUP_ANTIALIAS_OFF		(0x0020)

#define ANALOG_SETUP_RANGE_MASK			(~0x000F)
#define ANALOG_SETUP_INPUT_AMP_ON		(0x0008)

#define ANALOG_SETUP_INPUT_HI_MASK		(~0x0080)
#define ANALOG_SETUP_INPUT_HI_CONN		(0x0080)
#define ANALOG_SETUP_INPUT_HI_GROUND		(0x0000)

#define ANALOG_SETUP_INPUT_LO_MASK		(~0x0040)
#define ANALOG_SETUP_INPUT_LO_FLOAT		(0x0000)
#define ANALOG_SETUP_INPUT_LO_GROUND		(0x0040)
	
#define ANALOG_SETUP_COUPLING_MASK		(~0x0010)
#define ANALOG_SETUP_COUPLING_DC		(0x0010)
#define ANALOG_SETUP_COUPLING_AC		(0x0000)
	
/* defines for bit positions in the Measurement Control Register */
#define MEAS_CONTROL_OPCODE_MASK		(~0x0003)
#define MEAS_CONTROL_RESET_DSP_MODE		(0x0000)
#define MEAS_CONTROL_REG_LOAD_MODE		(0x0001)
#define MEAS_CONTROL_NORMAL_MODE		(0x0002)
#define MEAS_CONTROL_IDLE_MODE			(0x0003)

#define MEAS_CONTROL_SYNC_MASK			(~0x0004)
#define MEAS_CONTROL_SYNC_ON			(0x0004)
#define MEAS_CONTROL_SYNC_OFF			(0x0000)


/* defines for the bit positions of the Data Format Register */
#define DATA_FORMAT_BLOCK_MODE_MASK		(~0x0001)
#define DATA_FORMAT_BLOCK_MODE_OFF		(0x0000)
#define DATA_FORMAT_BLOCK_MODE_ON		(0x0001)

#define DATA_FORMAT_DATA_TYPE_MASK		(~0x0002)
#define DATA_FORMAT_DATA_TYPE_REAL		(0x0000)
#define DATA_FORMAT_DATA_TYPE_COMPLEX		(0x0002)

#define DATA_FORMAT_DATA_SIZE_MASK		(~0x0004)
#define DATA_FORMAT_DATA_SIZE_16		(0x0000)
#define DATA_FORMAT_DATA_SIZE_32		(0x0004)

#define DATA_FORMAT_DECIMATE_MASK		(~0x0008)
#define DATA_FORMAT_DECIMATE_OFF		(0x0000)
#define DATA_FORMAT_DECIMATE_ON  		(0x0008)

#define DATA_FORMAT_PASSOUT_MASK		(~0x01F0)
#define DATA_FORMAT_PASSOUT_BIT_SHIFT		(4)

#define DATA_FORMAT_FILTER_MULTIPASS_MASK	(~0x0200)
#define DATA_FORMAT_FILTER_ONEPASS		(0x0000)
#define DATA_FORMAT_FILTER_MULTIPASS		(0x0200)

#define DATA_FORMAT_PASSTAG_MASK		(~0x0400)
#define DATA_FORMAT_PASSTAG_32			(0x0000)
#define DATA_FORMAT_PASSTAG_24			(0x0400)

#define DATA_FORMAT_APPEND_STATUS_MASK		(~0x0800)
#define DATA_FORMAT_APPEND_STATUS_OFF		(0x0000)
#define DATA_FORMAT_APPEND_STATUS_ON		(0x0800)

/* defines for bit positions in the Interrupt Mask Register */
#define IRQ_CONFIG_PRIORITY_MASK		(~0x0007)
#define IRQ_CONFIG_MASK_MASK			(~0x3F00)

#define IRQ_CONFIG_READ_VALID			(0x0100)
#define IRQ_CONFIG_BLOCK_READY			(0x0200)
#define IRQ_CONFIG_ARMED			(0x0400)
#define IRQ_CONFIG_MEAS_DONE			(0x0800)
#define IRQ_CONFIG_OVERLOAD			(0x1000)
#define IRQ_CONFIG_ADC_ERROR			(0x2000)

/* defines for bit positions in the Port Control Register */
#define PORT_CONTROL_LBUS_ENABLE_MASK		(~0x0001)
#define PORT_CONTROL_LBUS_DISABLE		(0x0000)
#define PORT_CONTROL_LBUS_ENABLE		(0x0001)

#define PORT_CONTROL_LBUS_PIPE_MASK		(~0x0002)
#define PORT_CONTROL_LBUS_PIPE_OFF		(0x0000)
#define PORT_CONTROL_LBUS_PIPE_ON		(0x0002)

#define PORT_CONTROL_SEND_PORT_MASK		(~0x00E0)
#define PORT_CONTROL_SEND_PORT_LBUS		(0x0040)
#define PORT_CONTROL_SEND_PORT_VME		(0x0060)

#define PORT_CONTROL_LBUS_MODE_MASK		(~0x0300)
#define PORT_CONTROL_LBUS_GENERATE		(0x0000)
#define PORT_CONTROL_LBUS_APPEND		(0x0100)
#define PORT_CONTROL_LBUS_INSERT		(0x0200)
#define PORT_CONTROL_LBUS_PIPELINE		(0x0300)

/* defines for the Trigger Setup Register */
#define TRIGGER_SETUP_LEVEL_MASK		(~0x00FF)

#define TRIGGER_SETUP_TRIG_AUTO_MASK		(~0x0100)
#define TRIGGER_SETUP_TRIG_AUTO_OFF		(0x0100)
#define TRIGGER_SETUP_TRIG_AUTO_ON		(0x0000)

#define TRIGGER_SETUP_SLOPE_MASK		(~0x0200)
#define TRIGGER_SETUP_SLOPE_POS			(0x0000)
#define TRIGGER_SETUP_SLOPE_NEG			(0x0200)

#define TRIGGER_SETUP_SOURCE_MASK		(~0x0400)
#define TRIGGER_SETUP_SOURCE_EXT		(0x0000)
#define TRIGGER_SETUP_SOURCE_INT		(0x0400)

#define TRIGGER_SETUP_INTERNAL_MASK		(~0x0800)
#define TRIGGER_SETUP_INTERNAL_ADC		(0x0000)
#define TRIGGER_SETUP_INTERNAL_MAG		(0x0800)

#define TRIGGER_SETUP_TRIG_DISABLE_MASK		(~0x1000)
#define TRIGGER_SETUP_TRIG_ENABLE		(0x0000)
#define TRIGGER_SETUP_TRIG_DISABLE		(0x1000)

/* defines for the Trigger Blocksize Register */
#define TRIGGER_BLOCKSIZE_HI_OFFSET_MASK	(~0x007F)
#define TRIGGER_BLOCKSIZE_HI_BIT_SHIFT		(16)

#define TRIGGER_BLOCKSIZE_PRE_POST_MASK		(~0x0200)
#define TRIGGER_BLOCKSIZE_POST_TRIGGER		(0x0000)
#define TRIGGER_BLOCKSIZE_PRE_TRIGGER		(0x0200)

#define TRIGGER_BLOCKSIZE_BLOCK_MASK		(~0x7C00)
#define TRIGGER_BLOCKSIZE_BIT_SHIFT		(10)

#define TRIGGER_BLOCKSIZE_REREAD_MASK		(~0x8000)
#define TRIGGER_BLOCKSIZE_REREAD_OFF		(0x0000)
#define TRIGGER_BLOCKSIZE_REREAD_ON		(0x8000)

/* defines for the Trigger Passout Register */
#define TRIGGER_PASSOUT_MASK			~(0x001F)

/* defines for the Timing Setup Register */
#define TIMING_SETUP_MULTI_SYNC_MASK		(~0x0001)
#define TIMING_SETUP_MULTI_SYNC_OFF		(0x0000)
#define TIMING_SETUP_MULTI_SYNC_ON		(0x0001)

#define TIMING_SETUP_MASTER_MASK		(~0x0002)
#define TIMING_SETUP_MASTER_OFF			(0x0000)
#define TIMING_SETUP_MASTER_ON			(0x0002)

#define TIMING_SETUP_ADC_CLOCK_MASK		(~0x0004)
#define TIMING_SETUP_ADC_CLOCK_INTERNAL		(0x0000)
#define TIMING_SETUP_ADC_CLOCK_EXTERNAL		(0x0004)

#define TIMING_SETUP_DSP_CLOCK_MASK		(~0x0008)
#define TIMING_SETUP_DSP_CLOCK_ADC		(0x0000)
#define TIMING_SETUP_DSP_CLOCK_INTERNAL		(0x0008)

#define TIMING_SETUP_TRACKING_MASK		(~0x0080)
#define TIMING_SETUP_TRACKING_OFF		(0x0000)
#define TIMING_SETUP_TRACKING_ON		(0x0080)

#define MEMORY_BIT_SHIFT			(8)

/* defines for bit fields in E1430_DECIMATION_CNTLAT_0_REG */
#define ALT_CNTLAT_MASK				0x0400
#define SHIFT_MASK				0x0300
#define CNTLAT_BIT_SHIFT			8

/* defines for bit positions in the ADC Control Register */
#define ADC_CONTROL_DIAG_MASK			(~0x001F)
#define ADC_CONTROL_DIAG_NORMAL			(0x0000)
#define ADC_CONTROL_DIAG_DAC3_BIT0		(0x0001)
#define ADC_CONTROL_DIAG_DAC3_BIT1		(0x0002)
#define ADC_CONTROL_DIAG_DAC3_BIT2		(0x0003)
#define ADC_CONTROL_DIAG_DAC3_BIT3		(0x0004)
#define ADC_CONTROL_DIAG_DAC3_BIT4		(0x0005)
#define ADC_CONTROL_DIAG_DAC3_BIT5		(0x0006)
#define ADC_CONTROL_DIAG_DAC3_BIT6		(0x0007)
#define ADC_CONTROL_DIAG_DAC3_BIT7		(0x0008)
#define ADC_CONTROL_DIAG_DAC3_BIT8		(0x0009)
#define ADC_CONTROL_DIAG_DAC2_BIT0		(0x000A)
#define ADC_CONTROL_DIAG_DAC2_BIT1		(0x000B)
#define ADC_CONTROL_DIAG_DAC2_BIT2		(0x000C)
#define ADC_CONTROL_DIAG_DAC2_BIT3		(0x000D)
#define ADC_CONTROL_DIAG_DAC2_BIT4		(0x000E)
#define ADC_CONTROL_DIAG_DAC2_BIT5		(0x000F)
#define ADC_CONTROL_DIAG_DAC2_BIT6		(0x0010)
#define ADC_CONTROL_DIAG_DAC2_BIT7		(0x0011)
#define ADC_CONTROL_DIAG_DAC2_BIT8		(0x0012)
#define ADC_CONTROL_DIAG_DAC2_BIT9		(0x0013)
#define ADC_CONTROL_DIAG_DAC1_BIT0		(0x0014)
#define ADC_CONTROL_DIAG_DAC1_BIT1		(0x0015)
#define ADC_CONTROL_DIAG_DAC1_BIT2		(0x0016)
#define ADC_CONTROL_DIAG_DAC1_BIT3		(0x0017)
#define ADC_CONTROL_DIAG_DAC1_BIT4		(0x0018)
#define ADC_CONTROL_DIAG_DAC1_BIT5		(0x0019)
#define ADC_CONTROL_DIAG_DAC1_BIT6		(0x001A)
#define ADC_CONTROL_DIAG_DAC1_BIT7		(0x001B)
#define ADC_CONTROL_DIAG_DAC1_BIT8		(0x001C)
#define ADC_CONTROL_DIAG_GAIN_ERR		(0x001D)
#define ADC_CONTROL_DIAG_ADC1_PASS1		(0x001E)
#define ADC_CONTROL_DIAG_ADC2_PASS2		(0x001F)

#define ADC_CONTROL_CAL_MODE_MASK		(~0x00E0)
#define ADC_CONTROL_CAL_MODE_RESET		(0x0000)
#define ADC_CONTROL_CAL_MODE_1			(0x0020)
#define ADC_CONTROL_CAL_MODE_2			(0x0040)
#define ADC_CONTROL_CAL_MODE_3			(0x0060)
#define ADC_CONTROL_CAL_MODE_4			(0x0080)
#define ADC_CONTROL_CAL_MODE_5			(0x00A0)
#define ADC_CONTROL_CAL_MODE_6			(0x00C0)
#define ADC_CONTROL_CAL_MODE_NORMAL		(0x00E0)

/* defines for bit positions in the Zoom Control Register */
#define ZOOM_CONTROL_OPCODE_MASK		(~0x0F)

#define ZOOM_CONTROL_FILTER_MASK		(~0x10)
#define ZOOM_CONTROL_FILTER_BYPASS		(0x00)
#define ZOOM_CONTROL_FILTER_ON			(0x10)
	
#define ZOOM_CONTROL_CLEAR_MASK			(~0x40)
#define ZOOM_CONTROL_CLEAR_OFF			(0x00)
#define ZOOM_CONTROL_CLEAR_ON			(0x40)

#define ZOOM_CONTROL_RESET_MASK			(~0x80)
#define ZOOM_CONTROL_RESET_OFF			(0x00)
#define ZOOM_CONTROL_RESET_ON			(0x80)


/* expected phase delay from trigger to first sample */
#define PHASE_DELAY		-33

/* the following pointers are left as defines so as to accomodate future
 * operating environments such as MSWindows, where memory "handles" are used
 * used to refer to memory instead of more direct pointers.  See modgroup.c
 * for an explaination of the data structures associated with module groups.
 */
typedef SHORTSIZ16 *aModGroupPtr;
typedef SHORTSIZ16 **aModHeadPtr;

/* internal structure of "shadow registers" showing current state of module */
typedef struct {	
  SHORTSIZ16	logicalAddr;		/* logical address of module */
  SHORTSIZ16	cage;			/* mainframe number 0 -> 7 */
  SHORTSIZ16	slot;			/* slot number 1 -> 13 */
  SHORTSIZ16 	analogSetup;		/* analog setup register */
  SHORTSIZ16 	offset;			/* input offset register */
  SHORTSIZ16	measControl;		/* measurment control register */
  SHORTSIZ16	dataFormat;		/* data format register */
  SHORTSIZ16	irqConfig0;		/* interrupt mask register 0 */
  SHORTSIZ16	irqConfig1;		/* interrupt mask register 1 */
  SHORTSIZ16	portControl;		/* port control register */
  SHORTSIZ16 	trigSetup;		/* trigger setup register */
  SHORTSIZ16 	trigBlocksize;		/* trigger blocksize register */
  SHORTSIZ16 	trigOffset;		/* trigger offset register */
  SHORTSIZ16 	trigPassout;		/* trigger filter bandwidth */
  SHORTSIZ16	timingSetup;		/* timing setup register */
  SHORTSIZ16	adcControl;		/* ADC control register */
  SHORTSIZ16	zoomPhase0;		/* zoom registers */
  SHORTSIZ16	zoomPhase1;		/* zoom registers */
  SHORTSIZ16	zoomInterp0;
  SHORTSIZ16	zoomInterp1;
  SHORTSIZ16	zoomInterp2;
  SHORTSIZ16	zoomInterp3;
  SHORTSIZ16	zoomControl;
  SHORTSIZ16 	trigLevelSave;		/* save the trigger levels */
  SHORTSIZ16 	trigSlopeSave;		/* save the trigger slope */
  LONGSIZ32	trigDelaySave;		/* save the trigger delay */
  SHORTSIZ16	offsetSave[RANGE_STEPS];	/* save offset for low ranges */
  FLOATSIZ32	sampleFreq;		/* external sample freq */
} aModuleImage;

/*********************** GLOBALS ****************************
 *
 *  This convoluted way of doing globals is to fit into the compiled SCPI 
 * scheme, which requires a different set of any globals that are writable
 * for each instance of the instrument driver that is envoked.  The
 * _HPVXI_DOWNLOAD case is for downloadable SCPI drivers in the Hard Commander
 *
 * Note that be defining NOTEXTERN_FLAG for only one source file that includes
 * trice.h, the global variables are allocated space ... all other files
 * should not have this defined so that the globals are only externed in these
 * files.
 */

#include "global.h"

extern const SHORTSIZ16 e1430_table[];

extern void *i1430_get_mem(ULONGSIZ32 size);
extern void i1430_free_mem(void *memPtr);
extern SHORTSIZ16 i1430_Error(SHORTSIZ16 error, char *str1, char *str2);
extern char *e1430_error_string_from_table(LONGSIZ32 errorNum);
extern SHORTSIZ16 i1430_report_bus_error(SHORTSIZ16 la, SHORTSIZ16 offset);
extern SHORTSIZ16 e1430_hard_reset(SHORTSIZ16 la);
extern SHORTSIZ16 i1430_reset_E1430(SHORTSIZ16 la);
extern SHORTSIZ16 i1430_init_mod_state(SHORTSIZ16 groupID, aModuleImage DOS_FAR *mod);
extern SHORTSIZ16 i1430_restore_state_la(SHORTSIZ16 la, aModuleImage DOS_FAR *mod);
extern aModGroupPtr i1430_valid_module_group(SHORTSIZ16 groupID);
extern SHORTSIZ16 i1430_number_of_modules(SHORTSIZ16 groupID);
extern SHORTSIZ16 i1430_get_first_la(SHORTSIZ16 groupID, SHORTSIZ16 *la);
extern SHORTSIZ16 i1430_get_index_from_la(SHORTSIZ16 la, SHORTSIZ16 *index);
extern SHORTSIZ16 i1430_get_slot_and_cage(SHORTSIZ16 la, SHORTSIZ16 *slot,
							SHORTSIZ16 *cage);
extern SHORTSIZ16 i1430_get_group_data_pt_size(SHORTSIZ16 groupID, 
							SHORTSIZ16 *size);
extern SHORTSIZ16 i1430_wait_for_sync_valid(SHORTSIZ16 la);
extern SHORTSIZ16 i1430_pull_sync(SHORTSIZ16 la, SHORTSIZ16 opcode);
extern SHORTSIZ16 i1430_release_sync(SHORTSIZ16 la, SHORTSIZ16 opcode);
extern SHORTSIZ16 i1430_start_meas_and_wait(SHORTSIZ16 la);
extern SHORTSIZ16 i1430_wait_for_block_ready_la(SHORTSIZ16 la, SHORTSIZ16 *status);
extern SHORTSIZ16 i1430_get_time(FLOATSIZ64 *secs);
extern SHORTSIZ16 e1430_pause(FLOATSIZ64 secs);
extern SHORTSIZ16 i1430_get_clock_tick(FLOATSIZ64 *tick);
extern void i1430_clear_masters_array(void);

extern char *i1430_get_register_name(SHORTSIZ16 reg, SHORTSIZ16 card);
extern SHORTSIZ16 i1430_set_module_int_state(SHORTSIZ16 la, 
						aModuleImage DOS_FAR *mod);
extern SHORTSIZ16 i1430_display_module_int_state(SHORTSIZ16 groupID); 
extern SHORTSIZ16 i1430_update_group_module_bits(SHORTSIZ16 groupID, 
			SHORTSIZ16 offset, SHORTSIZ16 mask, SHORTSIZ16 bits);

extern SHORTSIZ16 i1430_get_short_parm(SHORTSIZ16 groupID, 
	SHORTSIZ16 (*func)(SHORTSIZ16), char *errorStr, SHORTSIZ16 *parmPtr);
extern SHORTSIZ16 i1430_get_long_parm(SHORTSIZ16 groupID, 
	LONGSIZ32 (*func)(SHORTSIZ16), char *errorStr, LONGSIZ32 *parmPtr);
extern SHORTSIZ16 i1430_get_float_parm(SHORTSIZ16 groupID, 
	FLOATSIZ64 (*func)(SHORTSIZ16), char *errorStr, FLOATSIZ64 *parmPtr);

extern SHORTSIZ16 i1430_pause_meas(SHORTSIZ16 groupID);
extern SHORTSIZ16 i1430_continue_meas(SHORTSIZ16 groupID);

extern FLOATSIZ64 i1430_get_input_offset_index(SHORTSIZ16 index);
extern FLOATSIZ64 i1430_get_range_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_range_bits_index(SHORTSIZ16 index, SHORTSIZ16 *bitsPtr);
extern SHORTSIZ16 i1430_get_alias_filter_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_coupling_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_input_hi_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_input_lo_index(SHORTSIZ16 index);
extern FLOATSIZ64 i1430_get_center_freq_index(SHORTSIZ16 index);
extern LONGSIZ32 i1430_get_blocksize_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_data_mode_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_adc_clock_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_dsp_clock_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_data_port_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_sync_state_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_pass_tag_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_append_status_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_data_type_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_data_size_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_trigger_bw_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_trigger_mode_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_trigger_slope_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_trigger_source_index(SHORTSIZ16 index);
extern FLOATSIZ64 i1430_get_trig_lev_adc_index(SHORTSIZ16 index);
extern FLOATSIZ64 i1430_get_trig_lev_mag_index(SHORTSIZ16 index);
extern LONGSIZ32 i1430_get_trigger_delay_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_trigger_phase_bits(SHORTSIZ16 la, LONGSIZ32 *phasePtr);
extern SHORTSIZ16 i1430_get_decimation_bw_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_deci_state_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_deci_output_index(SHORTSIZ16 index);
extern SHORTSIZ16 i1430_get_intr_priority_index(SHORTSIZ16 index, SHORTSIZ16 intrNum);
extern SHORTSIZ16 i1430_get_intr_mask_index(SHORTSIZ16 index, SHORTSIZ16 intrNum);
extern SHORTSIZ16 i1430_get_blocksize_bits(SHORTSIZ16 groupID, LONGSIZ32 blocksize,
						SHORTSIZ16 *bitsPtr);


#endif /*_TRICE_INCLUDED */
